//=============================================================================
// MarkistanMenuSelectDifficulty
//=============================================================================

class MarkistanMenuSelectDifficulty expands MenuSelectDifficulty;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();
}

// ----------------------------------------------------------------------
// WindowReady() 
// ----------------------------------------------------------------------

event WindowReady()
{
	// Set focus to the Medium button
	SetFocusWindow(winButtons[1]);
}

// ----------------------------------------------------------------------
// ProcessCustomMenuButton()
// ----------------------------------------------------------------------

function ProcessCustomMenuButton(string key)
{
	switch(key)
	{
		case "EASY":
			InvokeNewGameScreen(1.0);
			break;

		case "MEDIUM":
			InvokeNewGameScreen(1.5);
			break;

		case "HARD":
			InvokeNewGameScreen(2.0);
			break;

		case "REALISTIC":
			InvokeNewGameScreen(4.0);
			break;
	}
}

// ----------------------------------------------------------------------
// InvokeNewGameScreen()
// ----------------------------------------------------------------------

function InvokeNewGameScreen(float difficulty)
{
	local MarkistanMenuScreenNewGame newGame;

	newGame = MarkistanMenuScreenNewGame(root.InvokeMenuScreen(Class'Markistan.MarkistanMenuScreenNewGame'));

	if (newGame != None)
		newGame.SetDifficulty(difficulty);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
